/*
 * Decompiled with CFR 0.152.
 */
package dev.jcputney.keycloak.extensions.theme.login;

import org.keycloak.models.PasswordPolicy;

public class PasswordPoliciesBean {
    private final Integer length;
    private final Integer maxLength;
    private final Integer lowerCase;
    private final Integer upperCase;
    private final Integer specialChars;
    private final Integer digits;
    private final Integer passwordHistory;
    private final Integer forceExpiredPasswordChange;
    private final boolean notUsername;
    private final boolean notEmail;

    public PasswordPoliciesBean(PasswordPolicy policy) {
        this.length = (Integer)policy.getPolicyConfig("length");
        this.maxLength = (Integer)policy.getPolicyConfig("maxLength");
        this.lowerCase = (Integer)policy.getPolicyConfig("lowerCase");
        this.upperCase = (Integer)policy.getPolicyConfig("upperCase");
        this.specialChars = (Integer)policy.getPolicyConfig("specialChars");
        this.digits = (Integer)policy.getPolicyConfig("digits");
        this.passwordHistory = (Integer)policy.getPolicyConfig("passwordHistory");
        this.forceExpiredPasswordChange = (Integer)policy.getPolicyConfig("forceExpiredPasswordChange");
        this.notUsername = policy.getPolicies().contains("notUsername");
        this.notEmail = policy.getPolicies().contains("notEmail");
    }

    public Integer getLength() {
        return this.length;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getLowerCase() {
        return this.lowerCase;
    }

    public Integer getUpperCase() {
        return this.upperCase;
    }

    public Integer getSpecialChars() {
        return this.specialChars;
    }

    public Integer getDigits() {
        return this.digits;
    }

    public Integer getPasswordHistory() {
        return this.passwordHistory;
    }

    public Integer getForceExpiredPasswordChange() {
        return this.forceExpiredPasswordChange;
    }

    public boolean isNotUsername() {
        return this.notUsername;
    }

    public boolean isNotEmail() {
        return this.notEmail;
    }
}

